
#include <SPI.h>
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#define OLED_RESET 4
Adafruit_SSD1306 display(OLED_RESET);

int button = 2;
int red = 13;
int green = 12;
int yellow = 11;

int nDevices;
int device[127];
char* namen[]={ "0", "0", "0", "0", "0", "0", "0", "0", "Servo", "Linefollower",
                "Motorboard", "Utrasonic sensor", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "Oled", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0", "0", "0", "0", "0",
                "0", "0", "0", "0", "0", "0"};

void setup() {
  Serial.begin(9600);
  pinMode(red, OUTPUT);
  pinMode(green, OUTPUT);
  pinMode(yellow, OUTPUT);
  pinMode( button, INPUT);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  display.setRotation(2); 
    
  schowStart(300);
  scan();

}

bool buttonStart = false;
void loop() {

  
  if( digitalRead(button) == 0){
    buttonStart = true;
    show("Start");
  }

  if(buttonStart == true){
    if(device[9] == 1){


    //show values
    Wire.requestFrom(9,6);   

    while (Wire.available()) { 
      
      display.clearDisplay();
      display.setTextSize(1);
      display.setCursor(0,0);
      display.print("S1: ");
      display.println(readNum()); 
      display.print("S2: ");
      display.println(readNum()); 
      display.print("S3: ");
      display.println(readNum()); 
      
      display.display();  

      }
      
      if(device[10] == 1){ 
        //linie verfolgen

        
      }
   
  }
  else if(device[11] == 1){

        getDistance(); 
  
    //bring glue
      if(device[8] == 1 && device[10] == 1){
        display.println(" ultraschall");
        display.println(" Motor");
        display.display();  

        sendTo(8,0); 
        delay(50);
        int spet = 150;
        sendToMotor(1,spet);
       
        
        while(getDistance() > 15) {}
  
        sendToMotor(0,0); 
        delay(500);
        sendToMotor(3,spet); 
        delay(1000);
        sendToMotor(0,0); 
        delay(2000);
        sendToMotor(1,spet); 
        delay(1000);
        sendToMotor(0,0); 
        

        sendTo(8,1); 
        buttontoStart();
      }else if(device[8] == 1){
        
        display.println(" ultraschall");
        display.display();  
        
        sendTo(8,0); 

       
        delay(1000);    
        sendTo(8,1); 
        delay(1000);

          
      }
      

    }
  
  else if(device[10] == 1){

    }
  
  }
  
  
  }

int getDistance(){
    Wire.requestFrom(11,2);   
    int dis = 255;
    while (Wire.available()) { 
      

      

       display.clearDisplay();
      display.setTextSize(1);
      display.setCursor(0,0);
      display.print("S1: ");
      dis = readNum();
      display.print(dis); 
      display.println(" cm");
      display.display();  

  
    }
  
  return dis;
}


int readNum(){
  byte a, b;
  int n;

  a = Wire.read();
  b = Wire.read();

  n = a;
  n = (n << 8) | b;
  return n;
}

void scan(){
  display.clearDisplay();
  display.setTextColor(WHITE);
  display.setTextSize(1);
  
  display.print("Scann");
  for(int i = 0 ; i < 3; i++){
  display.clearDisplay();
  display.setCursor(3,0);
  display.print("Scan"); 
  display.display();
  delay(50); 
  display.print(".");
  display.display();
  delay(50); 
  display.print(".");
  display.display();
  delay(50); 
  display.print(".");
  display.display();
  delay(50);
  }
  byte error, address;

  nDevices = 0;
  display.clearDisplay();
  for(address = 1; address < 127; address++ )
  {

  
    Wire.beginTransmission(address);
    error = Wire.endTransmission();
 
    if (error == 0)
    {

      device[address] = 1;
      display.setCursor(3,nDevices * 10);
      display.setTextSize(1);
      
      display.print(address);
      display.print(" "); 
      
      if(namen[address] == "0"){
        display.println("unknown");
      }else{
        display.println(namen[address]);
      }
      
      display.display();
      nDevices++;
      
    }
    
  }
  delay(2000);
  buttontoStart();

}

void buttontoStart(){
  buttonStart = false;
  display.clearDisplay();
  display.setCursor(0,0);
  display.print("Found ");   
  display.print(nDevices);
  display.println(" devices"); 
  display.println(" ");
  display.print("Press button to start");   
  display.display();  
}

void schowStart(int t){


 
  display.clearDisplay();
  display.setTextColor(WHITE);
  display.setTextSize(2);
  display.setCursor(3,0);
  display.println("Morph3Dbot");
  display.setTextSize(1.2);
  display.setCursor(5,24);
  display.println(" by Lena Hagenauer");
  display.setRotation(2); 
  display.display();
  digitalWrite(red, HIGH);
  delay(t);
  digitalWrite(yellow, HIGH);
  delay(t);
  digitalWrite(green, HIGH);
  delay(t);
  digitalWrite(red, LOW);
  delay(t);
  digitalWrite(yellow, LOW);
  delay(t);
  digitalWrite(green, LOW);
 
}

void show(char *n){

  display.clearDisplay();
  display.setTextSize(1);
  display.setCursor(0,0);
  display.println(n); 
  display.display();  
  
}

void sendTo(int to, int wat){
    Wire.beginTransmission(to);   
    Wire.write(wat);   
    Wire.endTransmission();  
}
void sendToMotor(int r, int sp){
    Wire.beginTransmission(10);   
    Wire.write(r); 
    Wire.write(sp);    
    Wire.endTransmission();  
    Wire.requestFrom(10,1); 
}
